/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.api;

import com.floragunn.searchguard.authc.rest.TenantAwareRestHandler;
import com.floragunn.signals.actions.watch.delete.DeleteWatchAction;
import com.floragunn.signals.actions.watch.delete.DeleteWatchRequest;
import com.floragunn.signals.actions.watch.delete.DeleteWatchResponse;
import com.floragunn.signals.actions.watch.get.GetWatchAction;
import com.floragunn.signals.actions.watch.get.GetWatchRequest;
import com.floragunn.signals.actions.watch.get.GetWatchResponse;
import com.floragunn.signals.actions.watch.put.PutWatchAction;
import com.floragunn.signals.actions.watch.put.PutWatchRequest;
import com.floragunn.signals.actions.watch.put.PutWatchResponse;
import com.floragunn.signals.api.SignalsBaseRestHandler;
import com.floragunn.signals.watch.Watch;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;

public class WatchApiAction
extends SignalsBaseRestHandler
implements TenantAwareRestHandler {
    public WatchApiAction(Settings settings) {
        super(settings);
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_signals/watch/{tenant}/{id}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_signals/watch/{tenant}/{id}"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/_signals/watch/{tenant}/{id}"));
    }

    protected final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String id = request.param("id");
        if (Strings.isNullOrEmpty((String)id)) {
            return channel -> this.errorResponse((RestChannel)channel, RestStatus.BAD_REQUEST, "No id specified");
        }
        switch (request.method()) {
            case GET: {
                return this.handleGet(id, request, (Client)client);
            }
            case PUT: {
                return this.handlePut(id, request, (Client)client);
            }
            case DELETE: {
                return this.handleDelete(id, request, (Client)client);
            }
        }
        throw new IllegalArgumentException(request.method() + " not supported");
    }

    protected BaseRestHandler.RestChannelConsumer handleGet(String id, RestRequest request, Client client) throws IOException {
        return channel -> client.execute((ActionType)GetWatchAction.INSTANCE, (ActionRequest)new GetWatchRequest(id), (ActionListener)new ActionListener<GetWatchResponse>(){

            public void onResponse(GetWatchResponse response) {
                if (response.isExists()) {
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, SignalsBaseRestHandler.convertToJson(channel, (ToXContent)response, Watch.WITHOUT_AUTH_TOKEN)));
                } else {
                    WatchApiAction.this.errorResponse(channel, RestStatus.NOT_FOUND, "Not found");
                }
            }

            public void onFailure(Exception e) {
                WatchApiAction.this.errorResponse(channel, e);
            }
        });
    }

    protected BaseRestHandler.RestChannelConsumer handleDelete(String id, RestRequest request, Client client) throws IOException {
        return channel -> client.execute((ActionType)DeleteWatchAction.INSTANCE, (ActionRequest)new DeleteWatchRequest(id), (ActionListener)new ActionListener<DeleteWatchResponse>(){

            public void onResponse(DeleteWatchResponse response) {
                if (response.getResult() == DocWriteResponse.Result.DELETED) {
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, SignalsBaseRestHandler.convertToJson(channel, (ToXContent)response, Watch.WITHOUT_AUTH_TOKEN)));
                } else {
                    WatchApiAction.this.errorResponse(channel, response.getRestStatus(), response.getMessage());
                }
            }

            public void onFailure(Exception e) {
                WatchApiAction.this.errorResponse(channel, e);
            }
        });
    }

    protected BaseRestHandler.RestChannelConsumer handlePut(String id, RestRequest request, Client client) throws IOException {
        if (request.getXContentType() != XContentType.JSON) {
            return channel -> this.errorResponse((RestChannel)channel, RestStatus.UNSUPPORTED_MEDIA_TYPE, "Watches must be of content type application/json");
        }
        BytesReference content = request.content();
        return channel -> client.execute((ActionType)PutWatchAction.INSTANCE, (ActionRequest)new PutWatchRequest(id, content, XContentType.JSON), (ActionListener)new ActionListener<PutWatchResponse>(){

            public void onResponse(PutWatchResponse response) {
                if (response.getResult() == DocWriteResponse.Result.CREATED || response.getResult() == DocWriteResponse.Result.UPDATED) {
                    channel.sendResponse((RestResponse)new BytesRestResponse(response.getRestStatus(), SignalsBaseRestHandler.convertToJson(channel, (ToXContent)response, Watch.WITHOUT_AUTH_TOKEN)));
                } else {
                    WatchApiAction.this.errorResponse(channel, response.getRestStatus(), response.getMessage(), response.getDetailJsonDocument());
                }
            }

            public void onFailure(Exception e) {
                WatchApiAction.this.errorResponse(channel, e);
            }
        });
    }

    public String getName() {
        return "Watch Action";
    }
}

